// function to show dependent dropdowns for "Site Display" field.

function hfcm_showotherboxes( type ) {
	var header = '<option value="header">'+ hfcm_localize.header +'</option>',
		before_content = '<option value="before_content">'+ hfcm_localize.before_content +'</option>',
		after_content = '<option value="after_content">'+ hfcm_localize.after_content +'</option>',
		footer = '<option value="footer">'+ hfcm_localize.footer +'</option>',
		all_options = header + before_content + after_content + footer;

	if (type == 'All') {
		jQuery('#ex_pages, #ex_posts,  #locationtr').show();
		hfcm_remember_loc( all_options );
		jQuery('#s_categories, #s_pages, #s_tags, #c_posttype, #lp_count, #s_posts').hide();
	}else if (type == 's_pages') {
		jQuery('#s_pages, #locationtr').show();
		hfcm_remember_loc( all_options );
		jQuery('#s_categories, #s_tags, #ex_pages, #ex_posts,  #c_posttype, #lp_count, #s_posts').hide();
	} else if (type == 's_posts') {
		jQuery('#s_posts, #locationtr').show();
		hfcm_remember_loc( all_options );
		jQuery('#s_pages, #s_categories, #ex_pages, #ex_posts,  #s_tags, #c_posttype, #lp_count').hide();
	} else if (type == 's_categories') {
		jQuery('#s_categories, #locationtr').show();
		hfcm_remember_loc( all_options );
		jQuery('#s_pages, #s_tags, #c_posttype, #ex_pages, #ex_posts,  #lp_count, #s_posts').hide();
	} else if (type == 's_custom_posts') {
		jQuery('#c_posttype, #locationtr').show();
		hfcm_remember_loc( all_options );
		jQuery('#s_categories, #s_tags, #s_pages, #ex_pages, #ex_posts,  #lp_count, #s_posts').hide();
	} else if (type == 's_tags') {
		hfcm_remember_loc( all_options );
		jQuery('#s_tags, #locationtr').show();
		jQuery('#s_categories, #s_pages, #c_posttype, #ex_pages, #ex_posts,  #lp_count, #s_posts').hide();
	} else if (type == 'latest_posts') {
		hfcm_remember_loc( all_options );
		jQuery('#s_pages, #s_categories, #s_tags, #ex_pages, #ex_posts,  #c_posttype, #s_posts').hide();
		jQuery('#lp_count, #locationtr').show();
	} else if (type == 'manual') {
		jQuery('#s_pages, #s_categories, #s_tags,#ex_pages, #ex_posts,  #c_posttype, #lp_count, #locationtr, #s_posts').hide();
	} else {
		hfcm_remember_loc( header + footer );
		jQuery('#s_pages, #s_categories, #s_tags, #c_posttype, #lp_count, #s_posts').hide();
		jQuery('#locationtr').show();
	}
}

function hfcm_remember_loc( new_html ) {
	var tmp = jQuery('#data_location option:selected').val();
	jQuery('#data_location').html( new_html );
	jQuery('#data_location option[value="' + tmp + '"]').prop( 'selected', true );
}

// init selectize.js
jQuery('#loader').show();
jQuery(function($) {

	var data = {
		action: 'hfcm-request',
		id: hfcm_localize.id,
		get_posts: true,
		security: hfcm_localize.security
	};

	$.post(
		ajaxurl,
		data,
		function(new_data) {
			var options = {
				plugins: ['remove_button'],
				options: new_data.posts,
				items: new_data.selected,
			};
			$('#loader').hide();
			$('#s_posts select').selectize( options );
			var options = {
				plugins: ['remove_button'],
				options: new_data.posts,
				items: new_data.excluded
			};
			$('#loader').hide();
			$('#ex_posts select').selectize( options );
		},
		'json', // ajax result format
	);
	// selectize all <select multiple> elements
	$('#s_pages select, #s_categories select, #c_posttype select, #s_tags select, #ex_pages select').selectize();
});
