<?php
namespace cnb\utils;

// don't load directly
defined( 'ABSPATH' ) || die( '-1' );

use stdClass;

class CnbUtils {
    /**
     * @param $object null|array|stdClass
     * @param $property
     *
     * @return mixed|null
     */
    public static function getPropertyOrNull($object, $property) {
        if ($object === null) return null;

        if(is_array($object) && array_key_exists($property, $object)) {
            return $object[$property];
        }

        if ($object instanceof stdClass && property_exists($object, $property)) {
            return $object->$property;
        }

        return null;
    }

}