<?php
namespace cnb\admin\models;

// don't load directly
use cnb\utils\CnbUtils;
use stdClass;
use WP_Error;

defined( 'ABSPATH' ) || die( '-1' );

class CnbDomain implements \JsonSerializable {

    public $id;
    public $name;
    public $interval;
    public $type;
    public $expires;
    /**
     * @var boolean
     */
    public $renew;
    public $timezone;
    /**
     * @var boolean
     */
    public $trackGA;
    /**
     * @var boolean
     */
    public $trackConversion;
    /**
     * @var CnbDomainProperties
     */
    public $properties;

    /**
     * If a stdClass is passed, it is transformed into a CnbDomain.
     * a WP_Error is ignored and return immediatly
     * a null if converted into an (empty) CnbDomain
     *
     * @param $object stdClass|array|WP_Error|null
     *
     * @return CnbDomain|WP_Error
     */
    public static function fromObject($object) {
        if ( is_wp_error( $object ) ) {
            return $object;
        }

        $domain = new CnbDomain();

        $domain->id = CnbUtils::getPropertyOrNull( $object, 'id' );
        $domain->name = CnbUtils::getPropertyOrNull( $object, 'name' );
        $domain->timezone = CnbUtils::getPropertyOrNull( $object, 'timezone' );
        $domain->type = CnbUtils::getPropertyOrNull( $object, 'type' );
        $properties = CnbUtils::getPropertyOrNull( $object, 'properties' );
        $domain->properties = CnbDomainProperties::fromObject($properties);
        $domain->trackGA = CnbUtils::getPropertyOrNull( $object, 'trackGA' );
        $domain->trackConversion = CnbUtils::getPropertyOrNull( $object, 'trackConversion' );
        $domain->renew = CnbUtils::getPropertyOrNull( $object, 'renew' );

        return $domain;
    }
    /**
     *
     * This changes the object itself, settings some sane defaults in case those are missing
     *
     * @param $domain CnbDomain|null
     * @param $domain_id number|null
     *
     * @returns CnbDomain
     */
    public static function setSaneDefault( $domain = null, $domain_id = null ) {
        if (is_wp_error($domain)) {
            return $domain;
        }

        if ( $domain === null ) {
            $domain = new CnbDomain();
        }

        if ( strlen( $domain_id ) > 0 && $domain_id == 'new' && empty( $domain->id ) ) {
            $domain->id = null;
        }
        if ( empty( $domain->timezone ) ) {
            $domain->timezone = null;
        }
        if ( empty( $domain->type ) ) {
            $domain->type = 'FREE';
        }
        if ( empty( $domain->properties ) ) {
            $domain->properties        = new CnbDomainProperties();
        }
        if (empty($domain->properties->scale)) {
            $domain->properties->scale = '1';
        }
        if (empty($domain->properties->debug)) {
            $domain->properties->debug = false;
        }
        if (empty($domain->properties->zindex)) {
            $domain->properties->zindex = 2147483647;
        }

        if ( empty( $domain->name ) ) {
            $domain->name = null;
        }
        if ( ! isset( $domain->trackGA ) ) {
            $domain->trackGA = false;
        }
        if ( ! isset( $domain->trackConversion ) ) {
            $domain->trackConversion = false;
        }
        return $domain;
    }

    public function toArray() {
        return array(
            'id' => $this->id,
            // TODO Make this complete??
        );
    }

    public function jsonSerialize() {
        return $this->toArray();
    }
}

class CnbDomainProperties implements \JsonSerializable  {
    /**
     * @var number 0.7 to 1.3 (normally 1)
     */
    public $scale;

    /**
     * @var boolean
     */
    public $debug;

    /**
     * @var number|string ("auto" is also allowed)
     */
    public $zindex;

    /**
     * @var string "true" or "false"
     */
    public $allowMultipleButtons;

    /**
     * If a stdClass is passed, it is transformed into a CnbDomainProperties.
     * a WP_Error is ignored and return immediatly
     * a null if converted into an (empty) CnbDomain
     *
     * @param $object stdClass|array|WP_Error|null
     *
     * @return CnbDomainProperties|WP_Error
     */
    public static function fromObject($object) {
        if ( is_wp_error( $object ) ) {
            return $object;
        }

        $properties = new CnbDomainProperties();
        $properties->scale = CnbUtils::getPropertyOrNull( $object, 'scale' );
        $properties->debug = CnbUtils::getPropertyOrNull( $object, 'debug' );
        $properties->zindex = CnbUtils::getPropertyOrNull( $object, 'zindex' );
        $properties->allowMultipleButtons = CnbUtils::getPropertyOrNull( $object, 'allowMultipleButtons' );

        return $properties;
    }

    public function toArray() {
        return array(
            'scale' => $this->scale,
            'debug' => $this->debug,
            'zindex' => $this->zindex,
            'allowMultipleButtons' => $this->allowMultipleButtons,
        );
}
    public function jsonSerialize() {
        return $this->toArray();
    }
}
