<?php
namespace cnb\admin\models;

// don't load directly
use cnb\utils\CnbUtils;
use stdClass;
use WP_Error;

defined( 'ABSPATH' ) || die( '-1' );

class CnbCondition implements \JsonSerializable {
    public $id;
    public $conditionType = 'URL';
    public $filterType;
    public $matchType;
    public $matchValue;

    /**
     * Should this Condition be deleted?
     * @var boolean
     */
    public $delete;

    /**
     * If a stdClass is passed, it is transformed into a CnbCondition.
     * a WP_Error is ignored and return immediatly
     * a null if converted into an (empty) CnbCondition
     *
     * @param $object stdClass|array|WP_Error|null
     *
     * @return CnbCondition|WP_Error
     */
    public static function fromObject($object) {
        if (is_wp_error($object)) return $object;

        $condition = new CnbCondition();

        $condition->id = CnbUtils::getPropertyOrNull($object, 'id');
        $condition->conditionType = CnbUtils::getPropertyOrNull($object, 'conditionType');
        $condition->filterType = CnbUtils::getPropertyOrNull($object, 'filterType');
        $condition->matchType = CnbUtils::getPropertyOrNull($object, 'matchType');
        $condition->matchValue = CnbUtils::getPropertyOrNull($object, 'matchValue');
        $condition->delete = CnbUtils::getPropertyOrNull($object, 'delete');

        return $condition;
    }

    public function toArray() {
        // Note, we do not export "delete", since that is only used internally
        return array(
            'id' => $this->id,
            'conditionType' => $this->conditionType,
            'filterType' => $this->filterType,
            'matchType' => $this->matchType,
            'matchValue' => $this->matchValue,
        );
    }

    public function jsonSerialize() {
        return $this->toArray();
    }
}
