<?php
namespace cnb\admin\models;

// don't load directly
use cnb\utils\CnbUtils;
use stdClass;
use WP_Error;

defined( 'ABSPATH' ) || die( '-1' );

class CnbApiKey implements \JsonSerializable {
    /**
     * @var string
     */
    public $id;
    /**
     * @var string
     */
    public $name;
    /**
     * @var string
     */
    public $key;

    /**
     * If a stdClass is passed, it is transformed into a CnbApiKey.
     * a WP_Error is ignored and return immediatly
     * a null if converted into an (empty) CnbApiKey
     *
     * @param $object stdClass|array|WP_Error|null
     *
     * @return CnbApiKey|WP_Error
     */
    public static function fromObject($object) {
        if ( is_wp_error( $object ) ) {
            return $object;
        }

        $apiKey = new CnbApiKey();
        $apiKey->id = CnbUtils::getPropertyOrNull( $object, 'id' );
        $apiKey->name = CnbUtils::getPropertyOrNull( $object, 'name' );
        $apiKey->key = CnbUtils::getPropertyOrNull( $object, 'key' );

        return $apiKey;

    }

        public function toArray() {
        return array(
            'id' => $this->id,
            'name' => $this->name,
            'key' => $this->key,
        );
    }

    public function jsonSerialize() {
        return $this->toArray();
    }
}
