function getCleanDomain() {
    return document.location.hostname;
}

function createButtonFromData(formData) {
    let domainType = 'FREE';
    if (formData && formData.domain) {
        domainType = formData.domain.type;
    }

    return {
        "userId": "local",
        "domains": [
            {
                "id": "domain",
                "user": "local",
                "type": domainType,
                "name": getCleanDomain()
            }
        ],
        "buttons": [
            {
                "id": "button",
                "domain": getCleanDomain(),
                "domainId": "domain",
                "active": true,
                "name": "Live preview",
                "type": formData.cnb.type,
                "options": formData.cnb.options,
                "multiButtonOptions": formData.cnb.multiButtonOptions,
                "actions": Object.values(formData.actions_ordered),
                "conditions": []
            }
        ],
        "actions": Object.values(formData.actions),
        "conditions": [],
        "options": {
            "debugMode": false,
            "cssLocation": formData.cnb_css_root + "/css/main.css",
            ...formData.options
        }
    }
}

/**
 * Via https://dev.to/afewminutesofcode/how-to-convert-an-array-into-an-object-in-javascript-25a4
 *
 * NOTE that this does not work for "daysOfWeek", since the proper order of the array is lost.
 */
function convertArrayToObject (array, key) {
    const initialValue = {};
    return array.reduce((obj, item) => {
        return {
            ...obj,
            [item[key]]: item,
        };
    }, initialValue);
}

function livePreview() {
    const parsedData = jQuery('.cnb-container').serializeAssoc()

    // Find a button via JS (instead of via a form)
    if (typeof cnb_button !== 'undefined') {
        parsedData.cnb = cnb_button
    }

    if (typeof cnb_options !== 'undefined') {
        parsedData.options = cnb_options
    }

    // Find the correct static base URL for the Client CSS file
    parsedData.cnb_css_root = 'https://static.callnowbutton.com';
    if (typeof cnb_css_root !== 'undefined') {
        parsedData.cnb_css_root = cnb_css_root
    }

    // Ensure it is always visible
    parsedData.cnb.options.displayMode = 'ALWAYS';

    // Ensure all Actions are visible
    if (typeof cnb_actions !== 'undefined' && cnb_ignore_schedule) {
        cnb_actions = cnb_actions.map((item) => {
           item.schedule.showAlways = true;
           return item
        });
    }

    if (!cnb_ignore_schedule) {
        jQuery('#phone-preview').addClass('using-scheduler')
    }

    // This ensures we keep the order in the table
    parsedData.actions_ordered = Object.values(parsedData.actions).map((item) => item.id)

    // Ensure a Multi button / Buttonbar gets its actions
    if (typeof cnb_actions !== 'undefined') {
        if (parsedData &&
            parsedData.actions
            && ((parsedData.actions[Object.keys(parsedData.actions)[0]]
            && parsedData.actions[Object.keys(parsedData.actions)[0]].actionType)
            || parsedData.actions.new)) {
            // Editing Multi & Full Button
            parsedData.actions = Object.assign(convertArrayToObject(cnb_actions, 'id'), parsedData.actions)

            // Since we're editing, we need to do this a bit different. Also see 'new' logic below
            parsedData.actions_ordered = Object.values(parsedData.actions).map((item) => item.id)

        } else {
            // Overview Multi & Full Button
            parsedData.actions = convertArrayToObject(cnb_actions, 'id')
        }
    }

    // Ensure a "new" Action (in case of a new SINGLE) gets an ID to work with
    if (parsedData && parsedData.actions && parsedData.actions.new) {
        parsedData.actions.new.id = 'new'
        parsedData.actions_ordered.pop()
        parsedData.actions_ordered.push('new')
    }

    if (typeof cnb_actions !== 'undefined') {
        cnb_actions = cnb_actions.map((item) => {
            item.schedule.showAlways = item.schedule.showAlways || item.schedule.showAlways === 'true'
            item.schedule.daysOfWeek = item.schedule.daysOfWeek.map((daysOfWeek) =>
                daysOfWeek
            )
            return item
        });
    }

    // Fix: Force all booleans for schedule (and force daysOfWeek into array)
    if (!cnb_ignore_schedule && parsedData.action_id && parsedData.actions &&
        parsedData.actions[parsedData.action_id]) {

        const showAlways = parsedData.actions[parsedData.action_id].schedule.showAlways;
        parsedData.actions[parsedData.action_id].schedule.showAlways = showAlways !== "false";

        const daysOfWeek = [0,1,2,3,4,5,6]
        let newDaysOfWeek = []
        for (const day in daysOfWeek) {
            const ele = jQuery('#cnb_weekday_' + day)
            newDaysOfWeek[day] = ele.prop('checked')
        }
        parsedData.actions[parsedData.action_id].schedule.daysOfWeek = newDaysOfWeek
    }

    // Fix iconenabled (should be true/false instead of 0/1)
    if (parsedData.action_id && parsedData.actions &&
        parsedData.actions[parsedData.action_id]) {
        const iconEnabled = parsedData.actions[parsedData.action_id].iconEnabled;
        parsedData.actions[parsedData.action_id].iconEnabled = iconEnabled !== "0";
    }

    if (typeof cnb_domain !== 'undefined') {
        parsedData.domain = cnb_domain;
    }

    // Ensure WhatsApp works
    if (parsedData.action_id && parsedData.actions &&
        parsedData.actions[parsedData.action_id] && parsedData.actions[parsedData.action_id].actionType === 'WHATSAPP') {
        const input = document.querySelector('#cnb_action_value_input_whatsapp');
        const iti = window.intlTelInputGlobals.getInstance(input);
        parsedData.actions[parsedData.action_id].actionValue = iti.getNumber()
    }

    // Delete old items
    jQuery('.cnb-single.call-now-button').remove()
    jQuery('.cnb-full.call-now-button').remove()
    jQuery('.cnb-multi.call-now-button').remove()
    jQuery('.cnb-message-modal').remove()

    const cnbData = createButtonFromData(parsedData);
    const previewContainer = jQuery('#cnb-button-preview')
    previewContainer.text('')
    if (typeof CNB !== 'undefined') {
        // pass "false" to ensure we do NOT add the client's native observers
        const result = CNB.render(cnbData, false);

        // If there is a modal, trigger it
        // The "parsedData.action_id" check is to ensure it does not expand on a FULL or MULTI overview page
        if (parsedData.action_id) {
            const whatsappButton = jQuery('.call-now-button a[data-action-type="WHATSAPP"]')
            if (whatsappButton.length > 0) {
                whatsappButton[0].dispatchEvent(new window.CustomEvent('toggle'));
            }
        }

        // If there is a Multibutton, expand it (test this AFTER the modal, so we only toggle if it isn't ALREADY expanded)
        const multiButton = jQuery('.cnb-multi.call-now-button:not(.cnb-expand) .cnb-floating-main')
        if (multiButton.length > 0) {
            multiButton[0].dispatchEvent(new window.CustomEvent('toggle'));
        }

        // Move the result into a new special div (if found)
        const button = jQuery('.cnb-single.call-now-button, .cnb-full.call-now-button, .cnb-multi.call-now-button').detach()
        if (previewContainer.length > 0) {
            previewContainer.append(button)
        }

        // There are no actions to work with...
        const previewMoment = jQuery('.cnb-preview-moment')
        previewMoment.show()
        if (parsedData.actions && Object.keys(parsedData.actions).length === 0) {
            let message = '<h3 class="cnb_inscreen_notification">Nothing to show yet...</h3><p class="cnb_inscreen_notification">Once you add an Action, a preview of your Button will be shown here..</p>'
            previewContainer.html(message)
            previewMoment.hide()
        } else if (result.length === 0 && !cnb_ignore_schedule) {
            let message = '<h3 class="cnb_inscreen_notification">Nothing to show...</h3><p class="cnb_inscreen_notification">Following your schedule there\'s <strong>nothing to display at the current time</strong>.</p>'
            message += '<p class="cnb_inscreen_notification">You can adjust the day and time at the top of this screen to preview what your visitors will see at the selected time.</p>'
            previewContainer.html(message)
        }

        return result
    }
}

/*** Scheduler: Day and Time selector **/

function updateScheduler(day, hour, minute) {
    const date = new Date()
    date.setHours(hour)
    date.setMinutes(minute)
    date.setSeconds(0)

    // Settings day is weird...
    const currentDay = date.getDay();
    const distance = day - currentDay;
    date.setDate(date.getDate() + distance);

    cnb_options.date = date.getTime()

    // Trigger a rerender
    livePreview()
}

function updateSchedulerCall() {
    const day = jQuery('#call-now-button-preview-selector-day').val()
    const hour = jQuery('#call-now-button-preview-selector-hour').val()
    const minute = jQuery('#call-now-button-preview-selector-minute').val()
    updateScheduler(day, hour, minute)

}

function initPreviewDayAndTimeSelector() {
    jQuery('.call-now-button-preview-selector').on('change', () => {
        updateSchedulerCall()
    })
}
/*** END: Scheduler: Day and Time selector **/


function initButtonEdit() {
    jQuery(() => {
        const idElement = jQuery('form.cnb-container :input[name="cnb[id]"]');
        if (idElement.length > 0 && !idElement.val().trim()) {
            return false;
        }

        // Load the required dependencies and render the preview once
        // All refreshes happen inside
        formToJson();
        livePreview()
        jQuery("form.cnb-container :input").on('change input', function() {
            livePreview()
        });
        // No need to call "livePreview", this is done via the ".done()" handler on cnb_delete_action()
        // jQuery('form.cnb-container a[data-ajax="true"]').on('change input', function() {});
    })
}

jQuery(() => {
    // This enables the scheduler (which can be disabled on a per-screen basis)
    window.cnb_ignore_schedule = false;

    initButtonEdit()

    initPreviewDayAndTimeSelector();

})
